# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1769 (net-snmp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63409);
 script_cve_id("CVE-2008-6123", "CVE-2008-4309");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-1769 (net-snmp)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to net-snmp
announced via advisory FEDORA-2009-1769.

Building option:
--without tcp_wrappers : disable tcp_wrappers support

ChangeLog:

* Mon Feb 16 2009 Jan Safranek  5.4.2.1-3
- fix tcp_wrappers integration (CVE-2008-6123)
* Mon Dec  1 2008 Jan Safranek  5.4.2.1-2
- rebuild for fixed rpm (#473420)
* Mon Nov  3 2008 Jan Safranek  5.4.2.1-1
- explicitly require the right version and release of net-snmp and
net-snmp-libs
- update to net-snmp-5.4.2.1 to fix CVE-2008-4309

References:

[ 1 ] Bug #485211 - CVE-2008-6123 net-snmp: snmp queries allowed from each remote host regardless of /etc/hosts.allow configuration (host sensitive information disclosure)
https://bugzilla.redhat.com/show_bug.cgi?id=485211

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update net-snmp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1769

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-1769 (net-snmp)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-gui", rpm:"net-snmp-gui~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-libs", rpm:"net-snmp-libs~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-perl", rpm:"net-snmp-perl~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-python", rpm:"net-snmp-python~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-utils", rpm:"net-snmp-utils~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-debuginfo", rpm:"net-snmp-debuginfo~5.4.2.1~3.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
