# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 459-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53157);
 script_cve_id("CVE-2003-0592");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 459-1 (kdelibs, kdelibs-crypto)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdelibs, kdelibs-crypto
announced via advisory DSA 459-1.

A vulnerability was discovered in KDE where the path restrictions on
cookies could be bypassed using encoded relative path components
(e.g., /../).  This means that a cookie which should only be sent by
the browser to an application running at /app1, the browser could
inadvertently include it with a request sent to /app2 on the same
server.

For the current stable distribution (woody) this problem has been
fixed in kdelibs version 4:2.2.2-6woody3 and kdelibs-crypto version
4:2.2.2-13.woody.9.

For the unstable distribution (sid) this problem was fixed in kdelibs
version 4:3.1.3-1.

We recommend that you update your kdelibs and kdelibs-crypto packages.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20459-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 459-1 (kdelibs, kdelibs-crypto)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs3-doc", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dev", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-bin", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-cups", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-alsa", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarts-dev", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-alsa", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkmid-dev", ver:"2.2.2-13.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs3-crypto", ver:"2.2.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
