# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1724-1 (moodle)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63410);
 script_cve_id("CVE-2009-0500", "CVE-2009-0502", "CVE-2008-5153");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1724-1 (moodle)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to moodle
announced via advisory DSA 1724-1.

Several vulnerabilities have been discovered in Moodle, an online
course management system.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-0500

It was discovered that the information stored in the log tables
was not properly sanitized, which could allow attackers to inject
arbitrary web code.

CVE-2009-0502

It was discovered that certain input via the Login as function
was not properly sanitised leading to the injection of arbitrary
web script.

CVE-2008-5153

Dmitry E. Oboukhov discovered that the SpellCheker plugin creates
temporary files insecurely, allowing a denial of service attack.
Since the plugin was unused, it is removed in this update.

For the stable distribution (etch) these problems have been fixed in
version 1.6.3-2+etch2.

For the testing (lenny) distribution these problems have been fixed in
version 1.8.2.dfsg-3+lenny1.

For the unstable (sid) distribution these problems have been fixed in
version 1.8.2.dfsg-4.

We recommend that you upgrade your moodle package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201724-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1724-1 (moodle)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"moodle", ver:"1.6.3-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
