# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1695-1 (ruby1.8, ruby1.9)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63099);
 script_cve_id("CVE-2008-3443");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1695-1 (ruby1.8, ruby1.9)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ruby1.8, ruby1.9
announced via advisory DSA 1695-1.

The regular expression engine of Ruby, a scripting language, contains a
memory leak which can be triggered remotely under certain circumstances,
leading to a denial of service condition (CVE-2008-3443).

In addition, this security update addresses a regression in the REXML
XML parser of the ruby1.8 package; the regression was introduced in
DSA-1651-1.

For the stable distribution (etch), this problem has been fixed in version
1.8.5-4etch4 of the ruby1.8 package, and version 1.9.0+20060609-1etch4
of the ruby1.9 package.

For the unstable distribution (sid), this problem has been fixed in
version 1.8.7.72-1 of the ruby1.8 package.  The ruby1.9 package will be
fixed soon.

We recommend that you upgrade your Ruby packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201695-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1695-1 (ruby1.8, ruby1.9)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0+20060609-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.5-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
