# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1451-1 (mysql-dfsg-5.0)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60106);
 script_cve_id("CVE-2007-3781", "CVE-2007-5969", "CVE-2007-6304");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1451-1 (mysql-dfsg-5.0)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mysql-dfsg-5.0
announced via advisory DSA 1451-1.

Several local/remote vulnerabilities have been discovered in the MySQL
database server. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-3781

It was discovered that privilege validation for the source table
of CREATE TABLE LIKE statements was insufficiently enforced, which
might lead to information disclosure. This is only exploitable by
authenticated users.

CVE-2007-5969

It was discovered that symbolic links were handled insecurely during
the creation of tables with DATA DIRECTORY or INDEX DIRECTORY
statements, which might lead to denial of service by overwriting
data. This is only exploitable by authenticated users.

CVE-2007-6304

It was discovered that queries to data in a FEDERATED table can
lead to a crash of the local database server, if the remote server
returns information with less columns than expected, resulting in
denial of service.

For the unstable distribution (sid), these problems have been fixed in
version 5.0.51-1.

For the stable distribution (etch), these problems have been fixed in
version 5.0.32-7etch4.

The the old stable distribution (sarge) doesn't contain mysql-dfsg-5.0.

We recommend that you upgrade your mysql-dfsg-5.0 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201451-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1451-1 (mysql-dfsg-5.0)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.32-7etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
