# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 099-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53761);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 099-1 (XChat)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to XChat
announced via advisory DSA 099-1.

zen-parse found a vulnerability in the XChat IRC client that allows an
attacker to take over the users IRC session.

It is possible to trick XChat IRC clients into sending arbitrary
commands to the IRC server they are on, potentially allowing social
engineering attacks, channel takeovers, and denial of service.  This
problem exists in versions 1.4.2 and 1.4.3.  Later versions of XChat
are vulnerable as well, but this behaviour is controlled by the
configuration variable percascii, which defaults to 0.  If it is set
to 1 then the problem becomes apparent in 1.6/1.8 a swell.

This problem has been fixed in upstream version 1.8.7 and in version
1.4.3-1 for the current stable Debian release (2.2) with a patch
provided from the upstream author Peter Zelezny.  We recommend that
you upgrade your XChat packages immediately, since this problem is
already actively being exploited.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20099-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 099-1 (XChat)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xchat-common", ver:"1.4.3-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xchat-gnome", ver:"1.4.3-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xchat-text", ver:"1.4.3-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xchat", ver:"1.4.3-1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
