# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 058-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53811);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 058-1 (exim)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to exim
announced via advisory DSA 058-1.

Megyer Laszlo found a printf format bug in the exim mail transfer
agent. The code that checks the header syntax of an email logs
an error without protecting itself against printf format attacks.

This problem has been fixed in version 3.12-10.1. Since that code is
not turned on by default a standard installation is not vulnerable,
but we still recommend to upgrade your exim package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20058-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 058-1 (exim)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"exim", ver:"3.12-10.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"eximon", ver:"3.12-10.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
