# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0473 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63947);
 script_cve_id("CVE-2008-4307", "CVE-2009-0787", "CVE-2009-0834", "CVE-2009-1336", "CVE-2009-1337");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0473";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to the kernel announced in
advisory RHSA-2009:0473.

This update fixes the following security issues:

* a logic error was found in the do_setlk() function of the Linux kernel
Network File System (NFS) implementation. If a signal interrupted a lock
request, the local POSIX lock was incorrectly created. This could cause a
denial of service on the NFS server if a file descriptor was closed before
its corresponding lock request returned. (CVE-2008-4307, Important)

* a deficiency was found in the Linux kernel system call auditing
implementation on 64-bit systems. This could allow a local, unprivileged
user to circumvent a system call audit configuration, if that configuration
filtered based on the syscall number or arguments.
(CVE-2009-0834, Important)

* the exit_notify() function in the Linux kernel did not properly reset the
exit signal if a process executed a set user ID (setuid) application before
exiting. This could allow a local, unprivileged user to elevate their
privileges. (CVE-2009-1337, Important)

* a flaw was found in the ecryptfs_write_metadata_to_contents() function of
the Linux kernel eCryptfs implementation. On systems with a 4096 byte
page-size, this flaw may have caused 4096 bytes of uninitialized kernel
memory to be written into the eCryptfs file headers, leading to an
information leak. Note: Encrypted files created on systems running the
vulnerable version of eCryptfs may contain leaked data in the eCryptfs file
headers. This update does not remove any leaked data. Refer to the
Knowledgebase article in the References section for further information.
(CVE-2009-0787, Moderate)

* the Linux kernel implementation of the Network File System (NFS) did not
properly initialize the file name limit in the nfs_server data structure.
This flaw could possibly lead to a denial of service on a client mounting
an NFS share. (CVE-2009-1336, Moderate)

For additional details on bugs fixed in this update, please visit
the referenced security advisories.

Users should upgrade to these updated packages, which contain backported
patches to correct these issues. The system must be rebooted for this
update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0473.html
http://www.redhat.com/security/updates/classification/#important
http://kbase.redhat.com/faq/docs/DOC-16748

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0473";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-debuginfo", rpm:"kernel-kdump-debuginfo~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-devel", rpm:"kernel-kdump-devel~2.6.18~128.1.10.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
