# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0420 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63764);
 script_cve_id("CVE-2007-6725", "CVE-2009-0792", "CVE-2009-0583");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0420";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0420.

Ghostscript is a set of software that provides a PostScript interpreter, a
set of C procedures (the Ghostscript library, which implements the graphics
capabilities in the PostScript language) and an interpreter for Portable
Document Format (PDF) files.

It was discovered that the Red Hat Security Advisory RHSA-2009:0345 did not
address all possible integer overflow flaws in Ghostscript's International
Color Consortium Format library (icclib). Using specially-crafted ICC
profiles, an attacker could create a malicious PostScript or PDF file with
embedded images that could cause Ghostscript to crash or, potentially,
execute arbitrary code when opened. (CVE-2009-0792)

A missing boundary check was found in Ghostscript's CCITTFax decoding
filter. An attacker could create a specially-crafted PostScript or PDF file
that could cause Ghostscript to crash or, potentially, execute arbitrary
code when opened. (CVE-2007-6725)

Users of ghostscript are advised to upgrade to these updated packages,
which contain backported patches to correct these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0420.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0420";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~7.05~32.1.20", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~7.05~32.1.20", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~7.05~32.1.20", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hpijs", rpm:"hpijs~1.3~32.1.20", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~7.07~33.2.el4_7.8", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~7.07~33.2.el4_7.8", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~7.07~33.2.el4_7.8", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~7.07~33.2.el4_7.8", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
