# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0408 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63759);
 script_cve_id("CVE-2009-0844", "CVE-2009-0845", "CVE-2009-0846");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0408";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0408.

Kerberos is a network authentication system which allows clients and
servers to authenticate to each other using symmetric encryption and a
trusted third party, the Key Distribution Center (KDC). The Generic
Security Service Application Program Interface (GSS-API) definition
provides security services to callers (protocols) in a generic fashion. The
Simple and Protected GSS-API Negotiation (SPNEGO) mechanism is used by
GSS-API peers to choose from a common set of security mechanisms.

An input validation flaw was found in the ASN.1 (Abstract Syntax Notation
One) decoder used by MIT Kerberos. A remote attacker could use this flaw to
crash a network service using the MIT Kerberos library, such as kadmind or
krb5kdc, by causing it to dereference or free an uninitialized pointer.
(CVE-2009-0846)

Multiple input validation flaws were found in the MIT Kerberos GSS-API
library's implementation of the SPNEGO mechanism. A remote attacker could
use these flaws to crash any network service utilizing the MIT Kerberos
GSS-API library to authenticate users or, possibly, leak portions of the
service's memory. (CVE-2009-0844, CVE-2009-0845)

All krb5 users should upgrade to these updated packages, which contain
backported patches to correct these issues. All running services using the
MIT Kerberos libraries must be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0408.html
http://www.redhat.com/security/updates/classification/#important
http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2009-001.txt
http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2009-002.txt

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0408";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"krb5-debuginfo", rpm:"krb5-debuginfo~1.6.1~31.el5_3.3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-libs", rpm:"krb5-libs~1.6.1~31.el5_3.3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-workstation", rpm:"krb5-workstation~1.6.1~31.el5_3.3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.6.1~31.el5_3.3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.6.1~31.el5_3.3", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
