# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0402 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63711);
 script_cve_id("CVE-2008-4190", "CVE-2009-0790");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0402";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0402.

Openswan is a free implementation of Internet Protocol Security (IPsec)
and Internet Key Exchange (IKE). IPsec uses strong cryptography to provide
both authentication and encryption services. These services allow you to
build secure tunnels through untrusted networks. Everything passing through
the untrusted network is encrypted by the IPsec gateway machine, and
decrypted by the gateway at the other end of the tunnel. The resulting
tunnel is a virtual private network (VPN).

Gerd v. Egidy discovered a flaw in the Dead Peer Detection (DPD) in
Openswan's pluto IKE daemon. A remote attacker could use a malicious DPD
packet to crash the pluto daemon. (CVE-2009-0790)

It was discovered that Openswan's livetest script created temporary files
in an insecure manner. A local attacker could use this flaw to overwrite
arbitrary files owned by the user running the script. (CVE-2008-4190)

Note: The livetest script is an incomplete feature and was not
automatically executed by any other script distributed with Openswan, or
intended to be used at all, as was documented in its man page. In these
updated packages, the script only prints an informative message and exits
immediately when run.

All users of openswan are advised to upgrade to these updated packages,
which contain backported patches to correct these issues. After installing
this update, the ipsec service will be restarted automatically.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0402.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0402";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"openswan", rpm:"openswan~2.6.14~1.el5_3.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan-debuginfo", rpm:"openswan-debuginfo~2.6.14~1.el5_3.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openswan-doc", rpm:"openswan-doc~2.6.14~1.el5_3.2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
