# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0261 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63370);
 script_cve_id("CVE-2008-4770");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0261";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0261.

Virtual Network Computing (VNC) is a remote display system which allows you
to view a computer's desktop environment not only on the machine where it
is running, but from anywhere on the Internet and from a wide variety of
machine architectures.

An insufficient input validation flaw was discovered in the VNC client
application, vncviewer. If an attacker could convince a victim to connect
to a malicious VNC server, or when an attacker was able to connect to
vncviewer running in the listen mode, the attacker could cause the
victim's vncviewer to crash or, possibly, execute arbitrary code.
(CVE-2008-4770)

Users of vncviewer should upgrade to these updated packages, which contain
a backported patch to resolve this issue. For the update to take effect,
all running instances of vncviewer must be restarted after the update is
installed.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0261.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0261";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"vnc", rpm:"vnc~4.0~0.beta4.1.8", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc-debuginfo", rpm:"vnc-debuginfo~4.0~0.beta4.1.8", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc-server", rpm:"vnc-server~4.0~0.beta4.1.8", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc", rpm:"vnc~4.0~12.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc-debuginfo", rpm:"vnc-debuginfo~4.0~12.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc-server", rpm:"vnc-server~4.0~12.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc", rpm:"vnc~4.1.2~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc-debuginfo", rpm:"vnc-debuginfo~4.1.2~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vnc-server", rpm:"vnc-server~4.1.2~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
