###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_seamonkey_mult_vuln_feb09_win.nasl 986 2009-02-17 18:43:57Z feb $
#
# Mozilla Seamonkey Multiple Vulnerabilities Feb-09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900312);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0352", "CVE-2009-0353", "CVE-2009-0356",
                "CVE-2009-0357");
  script_bugtraq_id(33598);
  script_name(english:"Mozilla Seamonkey Multiple Vulnerabilities Feb-09 (Win)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Seamonkey browser and is prone
  to multiple vulnerabilities.

  Vulnerability Insight:
  Multiple flaws due to,
  - Vectors related to the layout engine and destruction of arbitrary layout
    objects by the 'nsViewManager::Composite' function.
  - Cookies marked 'HTTPOnly' are readable by JavaScript through the request
    calls of XMLHttpRequest methods i.e. XMLHttpRequest.getAllResponseHeaders
    and XMLHttpRequest.getResponseHeader.

  Impact:
  Successful exploitation could result in bypassing certain security
  restrictions, information disclosures, JavaScript code executions which
  can be executed with the privileges of the signed users.

  Impact Level: System/Application

  Affected Software/OS:
  Seamonkey version prior to 1.1.15 on Windows.

  Fix: Upgrade to Seamonkey version 1.1.15
  http://www.seamonkey-project.org/releases

  References:
  http://secunia.com/advisories/33808
  http://www.mozilla.org/security/announce/2009/mfsa2009-01.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-04.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-05.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("gb_seamonkey_detect_win.nasl");
  script_require_keys("Seamonkey/Win/Ver");
  exit(0);
}


include("version_func.inc");

smVer = get_kb_item("Seamonkey/Win/Ver");
if(!smVer){
  exit(0);
}

# Grep for Seamonkey version < 1.1.15
if(version_is_less(version:smVer, test_version:"1.1.15")){
  security_hole(0);
}
