###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-003.nasl 1017 2009-02-11 16:59:27Z feb $
#
# Vulnerabilities in Microsoft Exchange Could Allow Remote Code Execution (959239)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900079);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0098", "CVE-2009-0099");
  script_bugtraq_id(33134, 33136);
  script_name(english:"Vulnerabilities in Microsoft Exchange Could Allow Remote Code Execution (959239)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-003.

  Vulnerability Insight:
  - Error exists within the decoding of Transport Neutral Encapsulation
    Format (TNEF) data that causes memory corruption when a user opens or
    previews a specially crafted e-mail message sent in TNEF format.
  - Error exists within the processing of MAPI commands in the EMSMDB2.

  Impact:
  Successful exploitation allows remote arbitrary code execution sending
  a specially crafted MAPI command using the EMSMDB32 provider.

  Impact Level: System

  Affected Software/OS:
  Microsoft Exchange Server 2000/2003/2007 on Windows Servers

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-003.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-003.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, win2003:3) <= 0){
  exit(0);
}

appName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\Microsoft Exchange",
                          item:"DisplayName");
if(!appName){
  exit(0);
}

function Get_FileVersion()
{
  excFile = registry_get_sz(key:"SOFTWARE\Microsoft\Exchange\Setup",
                            item:"MsiInstallPath");
  if(!excFile){
    exit(0);
  }

  excFile += "\bin\Davex.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:excFile);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:excFile);

  dllVer = GetVer(file:file, share:share);
  if(!dllVer){
    return 0;
  }
  else return dllVer;
}


if("Micrsoft Exchange Server 2003" >< appName)
{
  if(hotfix_missing(name:"959897") == 0){
    exit(0);
  }

  fileVer = Get_FileVersion();
  if(!fileVer){
    exit(0);
  }

  # Check for version < 6.5.7654.12
  if(version_is_less(version:fileVer, test_version:"6.5.7654.12")){
    security_hole(0);
  }
}

else if("Microsoft Exchange Server 2007" >< appName)
{
  if(hotfix_missing(name:"959241") == 0){
    exit(0);
  }

  fileVer = Get_FileVersion();
  if(!fileVer){
    exit(0);
  }

  #  Check for version < 8.01.0336.0000
  if(version_is_less(version:fileVer, test_version:"8.01.0336.0000")){
    security_hole(0);
  }
}
