##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mini_stream_rm_downloader_bof_vuln.nasl 2349 2009-05-18 15:15:24Z may $
#
# Mini-stream RM Downloader Stack Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900645);
  script_version("Revision: 1.0");
  script_cve_id("CVE-2009-1646");
  script_bugtraq_id(34860);
  script_name(english:"Mini-stream RM Downloader Stack Overflow Vulnerability");
  desc["english"] = "

  Overview:
  This host has Mini-Stream RM Downloader installed and is prone to Stack
  Overflow Vulnerability.

  Vulnerability Insight:
  Inadequate validation of user supplied data while processing long rtsp URL
  in .ram files.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes through
  crafting a malicious '.ram' file and can cause application crash in the
  affected system.

  Impact Level: Application.

  Affected Software/OS:
  RM Downloader version 3.0.0.9 and prior on Windows

  Fix: No solution or patch is available as on 22nd May, 2009. Information
  regarding this issue will be updated once the solution details are available
  For updates refer, http://mini-stream.net/rm-downloader/download

  References:
  http://www.milw0rm.com/exploits/8628
  http://en.securitylab.ru/nvd/379630.php

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor : Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Checks for the version of Mini Stream RM Downloader");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_mini_stream_prdts_detect.nasl");
  script_require_keys("MiniStream/RMDown/Ver");
  exit(0);
}


include("version_func.inc");

rmDown = get_kb_item("MiniStream/RMDown/Ver");
if(rmDown)
{
  # Ministream RM Downloader 3.0.0.9 points to the version 3.0.2.1
  if(version_is_less_equal(version:rmDown, test_version:"3.0.2.1")){
    security_hole(0);
  }
}
