# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:016 (xen)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63203);
 script_cve_id("CVE-2008-0928", "CVE-2008-4405", "CVE-2008-4993");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:016 (xen)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xen
announced via advisory MDVSA-2009:016.

Ian Jackson found a security issue in the QEMU block device drivers
backend that could allow a guest operating system to issue a block
device request and read or write arbitrary memory locations, which
could then lead to privilege escalation (CVE-2008-0928).

It was found that Xen allowed unprivileged DomU domains to overwrite
xenstore values which should only be changeable by the privileged
Dom0 domain.  An attacker able to control a DomU domain could possibly
use this flaw to kill arbitrary processes in Dom0 or trick a Dom0
user into accessing the text console of a different domain running
on the same host.  This update makes certain parts of xenstore tree
read-only to unprivilged DomU domains (CVE-2008-4405).

A vulnerability in the qemu-dm.debug script was found in how it
created a temporary file in /tmp.  A local attacker in Dom0 could
potentially use this flaw to overwrite arbitrary files via a symlink
attack (CVE-2008-4993).  Since this script is not used in production,
it has been removed from this update package.

The updated packages have been patched to prevent these issues.

Affected: Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:016

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:016 (xen)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xen", rpm:"xen~3.0.1~3.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
