###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gnome-screensaver vulnerabilities USN-669-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840245);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "669-1");
  script_cve_id("CVE-2007-6389", "CVE-2008-0887");
  script_name(english: "Ubuntu Update for gnome-screensaver vulnerabilities USN-669-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that the notify feature in gnome-screensaver could let
  a local attacker read the clipboard contents of a locked session by
  using Ctrl-V. (CVE-2007-6389)
  
  Alan Matsuoka discovered that gnome-screensaver did not properly handle
  network outages when using a remote authentication service. During a
  network interruption, or by disconnecting the network cable, a local
  attacker could gain access to locked sessions. (CVE-2008-0887)

  Affected Software/OS:
  gnome-screensaver vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000776.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnome-screensaver vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.14.3-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.20.0-0ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}