###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for rdesktop vulnerabilities USN-646-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840349);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "646-1");
  script_cve_id("CVE-2008-1801", "CVE-2008-1802", "CVE-2008-1803");
  script_name(english: "Ubuntu Update for rdesktop vulnerabilities USN-646-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that rdesktop did not properly validate the length
  of packet headers when processing RDP requests. If a user were tricked
  into connecting to a malicious server, an attacker could cause a
  denial of service or possible execute arbitrary code with the
  privileges of the user. (CVE-2008-1801)
  
  Multiple buffer overflows were discovered in rdesktop when processing
  RDP redirect requests. If a user were tricked into connecting to a
  malicious server, an attacker could cause a denial of service or
  possible execute arbitrary code with the privileges of the user.
  (CVE-2008-1802)
  
  It was discovered that rdesktop performed a signed integer comparison
  when reallocating dynamic buffers which could result in a heap-based
  overflow. If a user were tricked into connecting to a malicious
  server, an attacker could cause a denial of service or possible
  execute arbitrary code with the privileges of the user.
  (CVE-2008-1802)

  Affected Software/OS:
  rdesktop vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-September/000750.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rdesktop vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"rdesktop", ver:"1.4.1-1.1ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"rdesktop", ver:"1.5.0-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"rdesktop", ver:"1.5.0-3+cvs20071006ubuntu0.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"rdesktop", ver:"1.5.0-2ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}