###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for xine-lib vulnerabilities USN-635-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840193);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "635-1");
  script_cve_id("CVE-2008-0073", "CVE-2008-0225", "CVE-2008-0238", "CVE-2008-0486", "CVE-2008-1110", "CVE-2008-1161", "CVE-2008-1482", "CVE-2008-1686", "CVE-2008-1878");
  script_name(english: "Ubuntu Update for xine-lib vulnerabilities USN-635-1");
  desc["english"] = "

  Vulnerability Insight:

  Alin Rad Pop discovered an array index vulnerability in the SDP
  parser. If a user or automated system were tricked into opening a
  malicious RTSP stream, a remote attacker may be able to execute
  arbitrary code with the privileges of the user invoking the program.
  (CVE-2008-0073)
  
  Luigi Auriemma discovered that xine-lib did not properly check
  buffer sizes in the RTSP header-handling code. If xine-lib opened an
  RTSP stream with crafted SDP attributes, a remote attacker may be
  able to execute arbitrary code with the privileges of the user
  invoking the program. (CVE-2008-0225, CVE-2008-0238)
  
  Damian Frizza and Alfredo Ortega discovered that xine-lib did not
  properly validate FLAC tags. If a user or automated system were
  tricked into opening a crafted FLAC file, a remote attacker may be
  able to execute arbitrary code with the privileges of the user
  invoking the program. (CVE-2008-0486)
  
  It was discovered that the ASF demuxer in xine-lib did not properly
  check the length if the ASF header. If a user or automated system
  were tricked into opening a crafted ASF file, a remote attacker
  could cause a denial of service or possibly execute arbitrary code
  with the privileges of the user invoking the program. (CVE-2008-1110)
  
  It was discovered that the Matroska demuxer in xine-lib did not
  properly verify frame sizes. If xine-lib opened a crafted ASF file,
  a remote attacker could cause a denial of service or possibly
  execute arbitrary code with the privileges of the user invoking
  the program. (CVE-2008-1161)
  
  Luigi Auriemma discovered multiple integer overflows in xine-lib. If
  a user or automated system were tricked into opening a crafted FLV,
  MOV, RM, MVE, MKV or CAK file, a remote attacker may be able to
  execute arbitrary code with the privileges of the user invoking the
  program. (CVE-2008-1482)
  
  It was discovered that xine-lib did not properly validate its input
  when processing Speex file headers. If a user or automated system
  were tricked into opening a specially crafted Speex file, an
  attacker could create a denial of service or possibly execute
  arbitrary code as the user invoking the program. (CVE-2008-1686)
  
  Guido Landi discovered a stack-based buffer overflow in xine-lib
  when processing NSF files. If xine-lib opened a specially crafted
  NSF file with a long NSF title, an attacker could create a denial of
  service or possibly execute arbitrary code as the user invoking the
  program. (CVE-2008-1878)

  Affected Software/OS:
  xine-lib vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-August/000741.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xine-lib vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.1+ubuntu2-7.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine-main1", ver:"1.1.1+ubuntu2-7.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-kde", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-console", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-ffmpeg", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-gnome", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine-extracodecs", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine-main1", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-plugins", ver:"1.1.4-2ubuntu3.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-bin", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-console", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-misc-plugins", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-x", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-ffmpeg", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-gnome", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-doc", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-all-plugins", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-plugins", ver:"1.1.11.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-console", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-ffmpeg", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-gnome", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-doc", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxine1-plugins", ver:"1.1.7-1ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}