###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for postgresql-8.1 regression USN-417-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840182);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "417-2");
  script_cve_id("");
  script_name(english: "Ubuntu Update for postgresql-8.1 regression USN-417-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-417-1 fixed several vulnerabilities in the PostgreSQL server.
  Unfortunately this update had a regression that caused some valid
  queries to be aborted with a type error. This update corrects that
  problem.
  
  We apologize for the inconvenience.

  Affected Software/OS:
  postgresql-8.1 regression on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000481.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql-8.1 regression");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.4-0ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.4-7ubuntu0.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}