###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for opera SUSE-SA:2007:050
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850092);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-050");
  script_cve_id("CVE-2007-4367");
  script_name(english: "SuSE Update for opera SUSE-SA:2007:050");
  desc["english"] = "

  Vulnerability Insight:

  The Opera web-browser allows an attacker to execute arbitrary code by
  providing an invalid pointer to a virtual function in JavaScript.
  This bug can be exploited automatically when a user visits a web-site that
  contains the attacker's JavaScript code.

  Impact:
  remote code execution

  Affected Software/OS:
  opera on SUSE LINUX 10.1, openSUSE 10.2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_50_opera.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of opera");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.23~3.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.23~2.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}