###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_streamripper_mult_bof_vuln_nov08_win.nasl 539 2008-11-26 15:35:25Z nov $
#
# Streamripper Multiple Buffer Overflow Vulnerabilities (Win)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800146);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-4829");
  script_bugtraq_id(32356);
  script_name(english:"Streamripper Multiple Buffer Overflow Vulnerabilities (Win)");
  desc["english"] = "

  Overview: The host is installed with Streamripper, which is prone to Multiple
  Buffer Overflow Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to boundary error within,
  - http_parse_sc_header() function in lib/http.c, when parsing an overly long
    HTTP header starting with Zwitterion v.
  - http_get_pls() and http_get_m3u() functions in lib/http.c, when parsing a
    specially crafted pls playlist containing an overly long entry or m3u
    playlist containing an overly long File entry.

  Impact:
  Successful attack could lead to execution of arbitrary code by tricking a
  user into connecting to a malicious server or can even cause denial of
  service condition.

  Impact Level: Application

  Affected Software/OS:
  Streamripper Version 1.63.5 and earlier on Windows.

  Fix: Upgrade to Version 1.64.0,
  http://streamripper.sourceforge.net/

  References:
  http://secunia.com/advisories/32562
  http://www.frsirt.com/english/advisories/2008/3207

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Streamripper");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

srPath = registry_get_sz(item:"UninstallString", key:"SOFTWARE\Microsoft" +
                         "\Windows\CurrentVersion\Uninstall\Streamripper");
if(!srPath){
  exit(0);
}

srFile = srPath - "Uninstall.exe" + "CHANGES";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:srFile);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:srFile);

srVer = read_file(share:share, file:file, offset:0, count:256);
srVer = eregmatch(pattern:"New for ([0-9.]+)", string:srVer);

if(srVer[1] != NULL )
{
  if(version_is_less(version:srVer[1], test_version:"1.64.0")){
    security_warning(0);
  }
}
