###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libpng MDKSA-2007:217 (libpng)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830002);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:217");
  script_cve_id("CVE-2007-5266", "CVE-2007-5268", "CVE-2007-5269");
  script_name(english: "Mandriva Update for libpng MDKSA-2007:217 (libpng)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple vulnerabilities were discovered in libpng:
  
  An off-by-one error when handling ICC profile chunks in the
  png_set_iCCP() function (CVE-2007-5266; only affects Mandriva Linux
  2008.0).
  
  George Cook and Jeff Phillips reported several errors in pngrtran.c,
  such as the use of logical instead of bitwise functions and incorrect
  comparisons (CVE-2007-5268; only affects Mandriva Linux 2008.0).
  
  Tavis Ormandy reported out-of-bounds read errors in several PNG chunk
  handling functions (CVE-2007-5269).
  
  Updated packages have been patched to correct these issues.
  For Mandriva Linux 2008.0, libpng 1.2.22 is being provided which
  corrects all three issues.

  Affected Software/OS:
  libpng on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00024.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libpng");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng3-devel", rpm:"libpng3-devel~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng3-static-devel", rpm:"libpng3-static-devel~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng", rpm:"libpng~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3-devel", rpm:"lib64png3-devel~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3-static-devel", rpm:"lib64png3-static-devel~1.2.13~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng3-devel", rpm:"libpng3-devel~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng3-static-devel", rpm:"libpng3-static-devel~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng", rpm:"libpng~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3-devel", rpm:"lib64png3-devel~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3-static-devel", rpm:"lib64png3-static-devel~1.2.12~2.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng-source", rpm:"libpng-source~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng-static-devel", rpm:"libpng-static-devel~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpng", rpm:"libpng~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png-devel", rpm:"lib64png-devel~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png-static-devel", rpm:"lib64png-static-devel~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.22~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}