###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for MySQL MDKSA-2007:177 (MySQL)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830297);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:177");
  script_cve_id("CVE-2007-3780", "CVE-2007-3782");
  script_name(english: "Mandriva Update for MySQL MDKSA-2007:177 (MySQL)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was found in MySQL's authentication protocol, making
  it possible for a remote unauthenticated attacker to send a specially
  crafted authentication request to the MySQL server causing it to crash
  (CVE-2007-3780).
  
  Another flaw was discovered in MySQL that allowed remote authenticated
  users to gain update privileges for a table in another database via
  a view that refers to the external table (CVE-2007-3782).
  
  Updated packages have been patched to prevent these issues.

  Affected Software/OS:
  MySQL on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-09/msg00005.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"MySQL", rpm:"MySQL~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-Max", rpm:"MySQL-Max~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-bench", rpm:"MySQL-bench~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-client", rpm:"MySQL-client~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-common", rpm:"MySQL-common~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-extra", rpm:"MySQL-ndb-extra~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-management", rpm:"MySQL-ndb-management~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-storage", rpm:"MySQL-ndb-storage~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-tools", rpm:"MySQL-ndb-tools~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15", rpm:"libmysql15~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-devel", rpm:"libmysql15-devel~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-static-devel", rpm:"libmysql15-static-devel~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15", rpm:"lib64mysql15~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-devel", rpm:"lib64mysql15-devel~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-static-devel", rpm:"lib64mysql15-static-devel~5.0.37~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"MySQL", rpm:"MySQL~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-Max", rpm:"MySQL-Max~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-bench", rpm:"MySQL-bench~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-client", rpm:"MySQL-client~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-common", rpm:"MySQL-common~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-extra", rpm:"MySQL-ndb-extra~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-management", rpm:"MySQL-ndb-management~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-storage", rpm:"MySQL-ndb-storage~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MySQL-ndb-tools", rpm:"MySQL-ndb-tools~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15", rpm:"libmysql15~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-devel", rpm:"libmysql15-devel~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15-static-devel", rpm:"libmysql15-static-devel~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15", rpm:"lib64mysql15~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-devel", rpm:"lib64mysql15-devel~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15-static-devel", rpm:"lib64mysql15-static-devel~5.0.24a~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}