###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gimp MDKSA-2007:170 (gimp)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830351);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:170");
  script_cve_id("CVE-2006-4519", "CVE-2007-2949", "CVE-2007-3741");
  script_name(english: "Mandriva Update for gimp MDKSA-2007:170 (gimp)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple integer overflows in the image loader plug-ins in GIMP before
  2.2.16 allow user-assisted remote attackers to execute arbitrary code
  via crafted length values in (1) DICOM, (2) PNM, (3) PSD, (4) PSP,
  (5) Sun RAS, (6) XBM, and (7) XWD files. (CVE-2006-4519)
  
  Integer overflow in the seek_to_and_unpack_pixeldata function in
  the psd.c plugin in Gimp 2.2.15 allows remote attackers to execute
  arbitrary code via a crafted PSD file that contains a large (1)
  width or (2) height value. (CVE-2007-2949)
  
  Victor Stinner has discovered several flaws in file plug-ins using
  his fuzzyfier tool fusil.  Several modified image files cause the
  plug-ins to crash or consume excessive amounts of memory due to
  insufficient input validation. Affected plug-ins: bmp, pcx, psd, psp
  (*.tub). (CVE-2007-3741)
  
  Updated packages have been patched to prevent these issues.

  Affected Software/OS:
  gimp on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-08/msg00015.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gimp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"gimp", rpm:"gimp~2.3.14~3.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gimp-python", rpm:"gimp-python~2.3.14~3.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimp2.0-devel", rpm:"libgimp2.0-devel~2.3.14~3.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimp2.0_0", rpm:"libgimp2.0_0~2.3.14~3.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gimp2.0-devel", rpm:"lib64gimp2.0-devel~2.3.14~3.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gimp2.0_0", rpm:"lib64gimp2.0_0~2.3.14~3.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"gimp", rpm:"gimp~2.3.10~6.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gimp-python", rpm:"gimp-python~2.3.10~6.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimp2.0-devel", rpm:"libgimp2.0-devel~2.3.10~6.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimp2.0_0", rpm:"libgimp2.0_0~2.3.10~6.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gimp2.0-devel", rpm:"lib64gimp2.0-devel~2.3.10~6.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gimp2.0_0", rpm:"lib64gimp2.0_0~2.3.10~6.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}