###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_java_prdts_detect_lin.nasl 1203 2009-04-10 15:24:35Z apr $
#
# Sun Java Products Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800385);
  script_version("Revision: 1.0 ");
  script_name(english:"Sun Java Products Version Detection (Linux)");
  desc["english"] = "
  Overview : This script finds the installed version of Java Products
  and sets the results in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the version of Java Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

# Check for Java Web Start
jwspaths = find_bin(prog_name:"javaws", sock:sock);
if(jwspaths)
{
  foreach jwsBin (jwspaths)
  {
    jwsVer = get_bin_version(full_prog_name:chomp(jwsBin), sock:sock,
                             version_argv:"-fullversion",
                             ver_pattern:"Java\(TM\) Web Start ([0-9_.]+)");
    if(jwsVer[1] != NULL){
      set_kb_item(name:"Java/WebStart/Linux/Ver", value:jwsVer[1]);
    }
  }
}

# Check for Java JRE
javapaths = find_bin(prog_name:"java", sock:sock);
if(javapaths)
{
  foreach javaBin (javapaths)
  {
    javaVer = get_bin_version(full_prog_name:chomp(javaBin), sock:sock,
                              version_argv:"-fullversion ",
                              ver_pattern:'java.? full version \"(.*)\"');
    # LibGCJ
    if("gcj" >< javaVer[1])
    {
      gcjVer = eregmatch(pattern:"([0-9]\.[0-9_.]+)", string:javaVer[2]);
      if(gcjVer[1] != NULL){
        set_kb_item(name:"Java/JRE/Linux/LibGCJ/Ver", value:gcjVer[1]);
      }
    }
    # IBM Java
    else if("IBM" >< javaVer[1]){
      ibmVer = eregmatch(pattern:"([0-9]\.[0-9._]+).*(SR[0-9]+)", string:javaVer[1]);
      if((ibmVer[1] && ibmVer[2]) != NULL)
      {
        ibmVer = ibmVer[1] + "." + ibmVer[2];
        set_kb_item(name:"IBM/Java/JRE/Linux/Ver", value:ibmVer);
      }
    }
    # Sun Java
    else if(javaVer[1] =~ "([0-9]\.[0-9._]+)-([b0-9]+)"){
      set_kb_item(name:"Sun/Java/JRE/Linux/Ver", value:javaVer[1]);
    }
  }
}
ssh_close_connection();
