###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for xorg-x11-server FEDORA-2008-0760
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860368);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-0760");
  script_cve_id("CVE-2007-5760", "CVE-2007-5958", "CVE-2007-6427", "CVE-2007-6428", "CVE-2007-6429", "CVE-2008-0006");
  script_name(english: "Fedora Update for xorg-x11-server FEDORA-2008-0760");
  desc["english"] = "

  Vulnerability Insight:
  X.Org X11 X server


  Affected Software/OS:
  xorg-x11-server on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00641.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xorg-x11-server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-debuginfo", rpm:"xorg-x11-server-debuginfo~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-source", rpm:"xorg-x11-server-source~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-sdk", rpm:"xorg-x11-server-sdk~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xephyr", rpm:"xorg-x11-server-Xephyr~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xvfb", rpm:"xorg-x11-server-Xvfb~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xdmx", rpm:"xorg-x11-server-Xdmx~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xnest", rpm:"xorg-x11-server-Xnest~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xorg", rpm:"xorg-x11-server-Xorg~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xvfb", rpm:"xorg-x11-server-Xvfb~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xnest", rpm:"xorg-x11-server-Xnest~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-debuginfo", rpm:"xorg-x11-server-debuginfo~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xorg", rpm:"xorg-x11-server-Xorg~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-source", rpm:"xorg-x11-server-source~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xdmx", rpm:"xorg-x11-server-Xdmx~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-sdk", rpm:"xorg-x11-server-sdk~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-Xephyr", rpm:"xorg-x11-server-Xephyr~1.3.0.0~39.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}