###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for mousepad FEDORA-2007-4385
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861174);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-4385");
  script_cve_id("");
  script_name(english: "Fedora Update for mousepad FEDORA-2007-4385");
  desc["english"] = "

  Vulnerability Insight:
  Mousepad is a text editor for Xfce based on Leafpad. The initial reason for
  Mousepad was to provide printing support, which would have been difficult
  for Leafpad for various reasons.
  
  Although some features are under development, currently Mousepad has following
  features:
  
      * Complete support for UTF-8 text
      * Cut/Copy/Paste and Select All text
      * Search and Replace
      * Font selecton
      * Word Wrap
      * Character coding selection
      * Auto character coding detection (UTF-8 and some codesets)
      * Manual codeset setting
      * Infinite Undo/Redo by word
      * Auto Indent
      * Multi-line Indent
      * Display line numbers
      * Drag and Drop
      * Printing


  Affected Software/OS:
  mousepad on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00543.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mousepad");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"mousepad", rpm:"mousepad~0.2.13~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mousepad", rpm:"mousepad~0.2.13~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mousepad-debuginfo", rpm:"mousepad-debuginfo~0.2.13~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mousepad", rpm:"mousepad~0.2.13~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mousepad-debuginfo", rpm:"mousepad-debuginfo~0.2.13~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}