###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for samba FEDORA-2007-3402
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861247);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-3402");
  script_cve_id("CVE-2007-4572", "CVE-2007-5398");
  script_name(english: "Fedora Update for samba FEDORA-2007-3402");
  desc["english"] = "

  Vulnerability Insight:
  Samba is the suite of programs by which a lot of PC-related machines
  share files, printers, and other information (such as lists of
  available files and printers). The Windows NT, OS/2, and Linux
  operating systems support this natively, and add-on packages can
  enable the same thing for DOS, Windows, VMS, UNIX of all kinds, MVS,
  and more. This package provides an SMB/CIFS server that can be used to
  provide network services to SMB/CIFS clients.
  Samba uses NetBIOS over TCP/IP (NetBT) protocols and does NOT
  need the NetBEUI (Microsoft Raw NetBIOS frame) protocol.


  Affected Software/OS:
  samba on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00472.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.0.27~0.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}