###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for dbus RHSA-2008:0159-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870109);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0159-01");
  script_cve_id("CVE-2008-0595");
  script_name(english: "RedHat Update for dbus RHSA-2008:0159-01");
  desc["english"] = "

  Vulnerability Insight:
  D-Bus is a system for sending messages between applications. It is used
  both for the system-wide message bus service, and as a
  per-user-login-session messaging facility.
  
  Havoc Pennington discovered a flaw in the way the dbus-daemon applies its
  security policy. A user with the ability to connect to the dbus-daemon may
  be able to execute certain method calls they should normally not have
  permission to access.  (CVE-2008-0595)
  
  Red Hat does not ship any applications in Red Hat Enterprise Linux 5 that
  would allow a user to leverage this flaw to elevate their privileges.
  
  This flaw does not affect the version of D-Bus shipped in Red Hat
  Enterprise Linux 4.
  
  All users are advised to upgrade to these updated dbus packages, which
  contain a backported patch and are not vulnerable to this issue.


  Affected Software/OS:
  dbus on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-February/msg00017.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dbus");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"dbus", rpm:"dbus~1.0.0~6.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-debuginfo", rpm:"dbus-debuginfo~1.0.0~6.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-devel", rpm:"dbus-devel~1.0.0~6.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-x11", rpm:"dbus-x11~1.0.0~6.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}