###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for ghostscript RHSA-2008:0155-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870133);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0155-01");
  script_cve_id("CVE-2008-0411");
  script_name(english: "RedHat Update for ghostscript RHSA-2008:0155-01");
  desc["english"] = "

  Vulnerability Insight:
  Ghostscript is a program for displaying PostScript files, or printing them
  to non-PostScript printers.
  
  Chris Evans from the Google Security Team reported a stack-based buffer
  overflow flaw in Ghostscript's zseticcspace() function. An attacker could
  create a malicious PostScript file that would cause Ghostscript to execute
  arbitrary code when opened. (CVE-2008-0411)
  
  These updated packages also fix a bug, which prevented the pxlmono printer
  driver from producing valid output on Red Hat Enterprise Linux 4.
  
  All users of ghostscript are advised to upgrade to these updated packages,
  which contain a backported patch to resolve these issues.


  Affected Software/OS:
  ghostscript on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-February/msg00016.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ghostscript");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.15.2~9.1.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~8.15.2~9.1.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.15.2~9.1.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~8.15.2~9.1.el5_1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~7.07~33.2.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~7.07~33.2.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~7.07~33.2.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~7.07~33.2.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~7.05~32.1.13", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~7.05~32.1.13", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~7.05~32.1.13", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hpijs", rpm:"hpijs~1.3~32.1.13", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}