###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for tcltk RHSA-2008:0134-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870139);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0134-01");
  script_cve_id("CVE-2008-0553", "CVE-2007-5378", "CVE-2007-4772");
  script_name(english: "RedHat Update for tcltk RHSA-2008:0134-01");
  desc["english"] = "

  Vulnerability Insight:
  Tcl is a scripting language designed for embedding into other applications
  and for use with Tk, a widget set.
  
  An input validation flaw was discovered in Tk's GIF image handling. A
  code-size value read from a GIF image was not properly validated before
  being used, leading to a buffer overflow. A specially crafted GIF file
  could use this to cause a crash or, potentially, execute code with the
  privileges of the application using the Tk graphical toolkit.
  (CVE-2008-0553)
  
  A buffer overflow flaw was discovered in Tk's animated GIF image handling.
  An animated GIF containing an initial image smaller than subsequent images
  could cause a crash or, potentially, execute code with the privileges of
  the application using the Tk library. (CVE-2007-5378)
  
  A flaw in the Tcl regular expression handling engine was discovered by Will
  Drewry. This flaw, first discovered in the Tcl regular expression engine
  used in the PostgreSQL database server, resulted in an infinite loop when
  processing certain regular expressions. (CVE-2007-4772)
  
  All users are advised to upgrade to these updated packages which contain
  backported patches which resolve these issues.


  Affected Software/OS:
  tcltk on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-February/msg00008.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tcltk");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"expect", rpm:"expect~5.38.0~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"itcl", rpm:"itcl~3.2~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcl", rpm:"tcl~8.3.3~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcllib", rpm:"tcllib~1.0~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tclx", rpm:"tclx~8.3~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tix", rpm:"tix~8.2.0b1~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tk", rpm:"tk~8.3.3~75", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"expect", rpm:"expect~5.38.0~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"expect-devel", rpm:"expect-devel~5.38.0~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"itcl", rpm:"itcl~3.2~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcl", rpm:"tcl~8.3.5~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcl-devel", rpm:"tcl-devel~8.3.5~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcltk-debuginfo", rpm:"tcltk-debuginfo~8.3.5~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tclx", rpm:"tclx~8.3~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tix", rpm:"tix~8.1.4~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tk", rpm:"tk~8.3.5~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tk-devel", rpm:"tk-devel~8.3.5~92.8", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}