###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for httpd RHSA-2008:0008-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870034);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0008-01");
  script_cve_id("CVE-2007-4465", "CVE-2007-5000", "CVE-2007-6388", "CVE-2007-6421", "CVE-2007-6422", "CVE-2008-0005");
  script_name(english: "RedHat Update for httpd RHSA-2008:0008-01");
  desc["english"] = "

  Vulnerability Insight:
  The Apache HTTP Server is a popular Web server.
  
  A flaw was found in the mod_imagemap module. On sites where mod_imagemap
  was enabled and an imagemap file was publicly available, a cross-site
  scripting attack was possible. (CVE-2007-5000)
  
  A flaw was found in the mod_autoindex module. On sites where directory
  listings are used, and the &quot;AddDefaultCharset&quot; directive has been removed
  from the configuration, a cross-site scripting attack might have been
  possible against Web browsers which do not correctly derive the response
  character set following the rules in RFC 2616. (CVE-2007-4465)
  
  A flaw was found in the mod_status module. On sites where mod_status was
  enabled and the status pages were publicly available, a cross-site
  scripting attack was possible. (CVE-2007-6388)
  
  A flaw was found in the mod_proxy_balancer module. On sites where
  mod_proxy_balancer was enabled, a cross-site scripting attack against an
  authorized user was possible. (CVE-2007-6421)
  
  A flaw was found in the mod_proxy_balancer module. On sites where
  mod_proxy_balancer was enabled, an authorized user could send a carefully
  crafted request that would cause the Apache child process handling that
  request to crash. This could lead to a denial of service if using a
  threaded Multi-Processing Module. (CVE-2007-6422) 
  
  A flaw was found in the mod_proxy_ftp module. On sites where mod_proxy_ftp
  was enabled and a forward proxy was configured, a cross-site scripting
  attack was possible against Web browsers which do not correctly derive the
  response character set following the rules in RFC 2616. (CVE-2008-0005)
  
  Users of Apache httpd should upgrade to these updated packages, which
  contain backported patches to resolve these issues. Users should restart
  httpd after installing this update.


  Affected Software/OS:
  httpd on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00009.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of httpd");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.3~11.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.2.3~11.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.2.3~11.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.2.3~11.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.2.3~11.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}