###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for ed CESA-2008:0946 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880093);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0946");
  script_cve_id("CVE-2008-3916");
  script_name(english: "CentOS Update for ed CESA-2008:0946 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  ed is a line-oriented text editor, used to create, display, and modify
  text files (both interactively and via shell scripts).
  
  A heap-based buffer overflow was discovered in the way ed, the GNU line
  editor, processed long file names. An attacker could create a file with a
  specially-crafted name that could possibly execute an arbitrary code when
  opened in the ed editor. (CVE-2008-3916)
  
  Users of ed should upgrade to this updated package, which contains
  a backported patch to resolve this issue.


  Affected Software/OS:
  ed on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-October/015335.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ed");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"ed", rpm:"ed~0.2~33.30E.1", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}