#
#VID defce068-39aa-11de-a493-001b77d09812
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID defce068-39aa-11de-a493-001b77d09812
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63966);
 script_cve_id("CVE-2009-1210", "CVE-2009-1268", "CVE-2009-1269");
 script_bugtraq_id(34291,34457);
 script_version ("$");
 name["english"] = "FreeBSD Ports: wireshark, wireshark-lite";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   wireshark
   wireshark-lite

CVE-2009-1210
Format string vulnerability in the PROFINET/DCP (PN-DCP) dissector in
Wireshark 1.0.6 and earlier allows remote attackers to execute
arbitrary code via a PN-DCP packet with format string specifiers in
the station name.  NOTE: some of these details are obtained from third
party information.

CVE-2009-1268
The Check Point High-Availability Protocol (CPHAP) dissector in
Wireshark 0.9.6 through 1.0.6 allows remote attackers to cause a
denial of service (crash) via a crafted FWHA_MY_STATE packet.

CVE-2009-1269
Unspecified vulnerability in Wireshark 0.99.6 through 1.0.6 allows
remote attackers to cause a denial of service (crash) via a crafted
Tektronix .rf5 file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.wireshark.org/security/wnpa-sec-2009-02.html
http://www.vuxml.org/freebsd/defce068-39aa-11de-a493-001b77d09812.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: wireshark, wireshark-lite";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wireshark");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.6")>=0 && revcomp(a:bver, b:"1.0.7")<0) {
    security_note(0, data:"Package wireshark version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wireshark-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.6")>=0 && revcomp(a:bver, b:"1.0.7")<0) {
    security_note(0, data:"Package wireshark-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
