#
#VID 6b4b0b3f-8127-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52185);
 script_cve_id("CVE-2005-0247");
 script_version ("$");
 name["english"] = "FreeBSD Ports: postgresql, postgresql-server, ja-postgresql";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   postgresql
   postgresql-server
   ja-postgresql

CVE-2005-0247
Multiple buffer overflows in gram.y for PostgreSQL 8.0.1 and earlier
may allow attackers to execute arbitrary code via (1) a large number
of variables in a SQL statement being handled by the
read_sql_construct function, (2) a large number of INTO variables in a
SELECT statement being handled by the make_select_stmt function, (3) a
large number of arbitrary variables in a SELECT statement being
handled by the make_select_stmt function, and (4) a large number of
INTO variables in a FETCH statement being handled by the
make_fetch_stmt function, a different set of vulnerabilities than
CVE-2005-0245.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://archives.postgresql.org/pgsql-committers/2005-02/msg00049.php
http://www.vuxml.org/freebsd/6b4b0b3f-8127-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: postgresql, postgresql-server, ja-postgresql";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"7.3.9_1")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>0 && revcomp(a:bver, b:"7.4.7_1")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8")>0 && revcomp(a:bver, b:"8.0.1_1")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"postgresql-server");
if(!isnull(bver) && revcomp(a:bver, b:"7.3.9_1")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>0 && revcomp(a:bver, b:"7.4.7_1")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8")>0 && revcomp(a:bver, b:"8.0.1_1")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"7.3.9_1")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>0 && revcomp(a:bver, b:"7.4.7_1")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8")>0 && revcomp(a:bver, b:"8.0.1_1")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
