#
#VID e5e2883d-ceb9-11d8-8898-000d6111a684
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52406);
 script_cve_id("CVE-2004-0627", "CVE-2004-0628");
 script_version ("$");
 name["english"] = "FreeBSD Ports: mysql-server";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-server

CVE-2004-0627
The check_scramble_323 function in MySQL 4.1.x before 4.1.3, and 5.0,
allows remote attackers to bypass authentication via a zero-length
scrambled string.

CVE-2004-0628
Stack-based buffer overflow in MySQL 4.1.x before 4.1.3, and 5.0,
allows remote attackers to cause a denial of service (crash) and
possibly execute arbitrary code via a long scramble string.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.nextgenss.com/advisories/mysql-authbypass.txt
http://dev.mysql.com/doc/mysql/en/News-4.1.3.html
http://secunia.com/advisories/12020
http://www.osvdb.org/7475
http://www.osvdb.org/7476
http://archives.neohapsis.com/archives/vulnwatch/2004-q3/0003.html
http://www.vuxml.org/freebsd/e5e2883d-ceb9-11d8-8898-000d6111a684.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: mysql-server";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-server");
if(!isnull(bver) && revcomp(a:bver, b:"4.1")>=0 && revcomp(a:bver, b:"4.1.3")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"5")>=0 && revcomp(a:bver, b:"5.0.0_2")<=0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
