#
#VID ccd325d2-fa08-11d9-bc08-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54424);
 script_cve_id("CVE-2004-1006");
 script_bugtraq_id(11591);
 script_version ("$");
 name["english"] = "isc-dhcpd -- format string vulnerabilities";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   isc-dhcp3-client
   isc-dhcp3-devel
   isc-dhcp3-relay
   isc-dhcp3-server
   isc-dhcp3
   isc-dhcp
   isc-dhcpd

CVE-2004-1006
Format string vulnerability in the log functions in dhcpd for dhcp 2.x
allows remote DNS servers to execute arbitrary code via certain DNS
messages, a different vulnerability than CVE-2002-0702.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=dhcp-announce&m=109996073218290
http://www.vuxml.org/freebsd/ccd325d2-fa08-11d9-bc08-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "isc-dhcpd -- format string vulnerabilities";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"isc-dhcp3-client");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcp3-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp3-devel");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcp3-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp3-relay");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcp3-relay version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp3-server");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcp3-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp3");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcp3 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcp version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcpd");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")<0) {
    security_note(0, data:"Package isc-dhcpd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
