#
#VID b9077cc4-6d04-4bcb-a37a-9ceaebfdcc9e
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID b9077cc4-6d04-4bcb-a37a-9ceaebfdcc9e
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63312);
 script_cve_id("CVE-2009-0241");
 script_version ("$");
 name["english"] = "FreeBSD Ports: ganglia-monitor-core, ganglia-monitor-webfrontend";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ganglia-monitor-core
   ganglia-monitor-webfrontend

CVE-2009-0241
Stack-based buffer overflow in the process_path function in
gmetad/server.c in Ganglia 3.1.1 allows remote attackers to cause a
denial of service (crash) via a request to the gmetad service with a
long pathname.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/33506
http://www.vuxml.org/freebsd/b9077cc4-6d04-4bcb-a37a-9ceaebfdcc9e.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: ganglia-monitor-core, ganglia-monitor-webfrontend";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ganglia-monitor-core");
if(!isnull(bver) && revcomp(a:bver, b:"3.1.1")<0) {
    security_note(0, data:"Package ganglia-monitor-core version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ganglia-monitor-webfrontend");
if(!isnull(bver) && revcomp(a:bver, b:"3.1.1")<0) {
    security_note(0, data:"Package ganglia-monitor-webfrontend version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
