#
#VID 18974c8a-1fbd-11d9-814e-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52339);
 script_cve_id("CVE-2004-0700");
 script_bugtraq_id(10736);
 script_version ("$");
 name["english"] = "FreeBSD Ports: apache+mod_ssl";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   apache+mod_ssl
   apache+mod_ssl+ipv6
   ru-apache+mod_ssl

CVE-2004-0700
Format string vulnerability in the mod_proxy hook functions function
in ssl_engine_log.c in mod_ssl before 2.8.19 for Apache before 1.3.31
may allow remote attackers to execute arbitrary messages via format
string specifiers in certain log messages for HTTPS that are handled
by the ssl_log function.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.openpkg.org/security/OpenPKG-SA-2004.032-apache.html
http://packetstormsecurity.org/0407-advisories/modsslFormat.txt
http://marc.theaimsgroup.com/?l=apache-modssl&m=109001100906749
http://www.vuxml.org/freebsd/18974c8a-1fbd-11d9-814e-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: apache+mod_ssl";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"apache+mod_ssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.31+2.8.19")<0) {
    security_note(0, data:"Package apache+mod_ssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache+mod_ssl+ipv6");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.31+2.8.19")<0) {
    security_note(0, data:"Package apache+mod_ssl+ipv6 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-apache+mod_ssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.31+30.20+2.8.19")<0) {
    security_note(0, data:"Package ru-apache+mod_ssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
