# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2295 (psi)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63489);
 script_cve_id("CVE-2008-6393");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-2295 (psi)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to psi
announced via advisory FEDORA-2009-2295.

This is a security-bugfix-only update to version 0.12.1 fixing a DOS
vulnerability.    New in 0.12.1   - Bugfix for DOS vulnerability in the file
transfer code.     Thanks to Jesus Olmos (jolmos@isecauditors.com)

ChangeLog:

* Tue Mar  3 2009 Sven Lankes  0.12.1-1
- version 0.12.1

References:

[ 1 ] Bug #488301 - CVE-2008-6393 psi: remote DoS vulnerability [F9]
https://bugzilla.redhat.com/show_bug.cgi?id=488301

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update psi' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2295

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-2295 (psi)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"psi", rpm:"psi~0.12.1~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psi-i18n", rpm:"psi-i18n~0.12.1~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psi-icons", rpm:"psi-icons~0.12.1~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psi-debuginfo", rpm:"psi-debuginfo~0.12.1~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
