# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2008-11351 (avahi)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63129);
 script_cve_id("CVE-2008-5081");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2008-11351 (avahi)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to avahi
announced via advisory FEDORA-2008-11351.

ChangeLog:

* Sun Dec 14 2008 Lennart Poettering  - 0.6.22-12
- Fix a couple of issues, rhbz #475394, avahi bts #209, rhbz #438013, avahi bts
All backported from upstream 0.6.24

References:

[ 1 ] Bug #475964 - CVE-2008-5081 avahi: avahi-daemon DoS (application abort) via packet with source port 0
https://bugzilla.redhat.com/show_bug.cgi?id=475964

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update avahi' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2008-11351

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2008-11351 (avahi)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-autoipd", rpm:"avahi-autoipd~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl", rpm:"avahi-compat-howl~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl", rpm:"avahi-compat-howl~devel~0.6.22", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-libdns_sd", rpm:"avahi-compat-libdns_sd~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-libdns_sd", rpm:"avahi-compat-libdns_sd~devel~0.6.22", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-devel", rpm:"avahi-devel~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-dnsconfd", rpm:"avahi-dnsconfd~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-glib", rpm:"avahi-glib~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-glib-devel", rpm:"avahi-glib-devel~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-gobject", rpm:"avahi-gobject~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-gobject-devel", rpm:"avahi-gobject-devel~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt3", rpm:"avahi-qt3~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt3-devel", rpm:"avahi-qt3-devel~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt4", rpm:"avahi-qt4~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt4-devel", rpm:"avahi-qt4-devel~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-sharp", rpm:"avahi-sharp~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-tools", rpm:"avahi-tools~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-ui", rpm:"avahi-ui~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-ui-devel", rpm:"avahi-ui-devel~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-ui-sharp", rpm:"avahi-ui-sharp~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-ui-tools", rpm:"avahi-ui-tools~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-debuginfo", rpm:"avahi-debuginfo~0.6.22~12.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
