# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 813-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55343);
 script_cve_id("CVE-2005-2369", "CVE-2005-2370", "CVE-2005-2448");
 script_bugtraq_id(14415);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 813-1 (centericq)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to centericq
announced via advisory DSA 813-1.

Several problems have been discovered in libgadu which is also part of
centericq, a text-mode multi-protocol instant messenger client.  The
Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2005-2369
Multiple integer signedness errors may allow remote attackers to
cause a denial of service or execute arbitrary code.

CVE-2005-2370
Memory alignment errors may allows remote attackers to cause a
denial of service on certain architectures such as sparc.

CVE-2005-2448
Several endianess errors may allow remote attackers to cause a
denial of service.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 4.20.0-1sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 4.20.0-9.

We recommend that you upgrade your centericq package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20813-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 813-1 (centericq)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"centericq", ver:"4.20.0-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq-common", ver:"4.20.0-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq-fribidi", ver:"4.20.0-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"centericq-utf8", ver:"4.20.0-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
