# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 771-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54477);
 script_cve_id("CVE-2005-2301", "CVE-2005-2302");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 771-1 (pdns)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to pdns
announced via advisory DSA 771-1.

Several problems have been discovered in pdns, a versatile nameserver
that can lead to a denial of service.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2301

Norbert Sendetzky and Jan de Groot discoverd that the LDAP backend
did not properly escape all queries, allowing it to fail and not
answer queries anymore.

CVE-2005-2302

Wilco Baan discovered that queries from clients without recursion
permission can temporarily blank out domains to clients with
recursion permitted.  This enables outside users to blank out a
domain temporarily to normal users.

The old stable distribution (woody) does not contain pdns packages.

For the stable distribution (sarge) these problems have been fixed in
version 2.9.17-13sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 2.9.18-1.

We recommend that you upgrade your pdns package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20771-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 771-1 (pdns)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pdns-doc", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-geo", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-ldap", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-mysql", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-pgsql", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-pipe", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-backend-sqlite", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-recursor", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pdns-server", ver:"2.9.17-13sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
