# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 476-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53174);
 script_bugtraq_id(10035);
 script_cve_id("CVE-2004-0371");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 476-1 (heimdal)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to heimdal
announced via advisory DSA 476-1.

According to a security advisory from the heimdal project:

http://www.pdc.kth.se/heimdal/advisory/2004-04-01/

heimdal, a suite of software implementing the Kerberos protocol, has
a cross-realm vulnerability allowing someone with control over a
realm to impersonate anyone in the cross-realm trust path.

For the current stable distribution (woody) this problem has been
fixed in version 0.4e-7.woody.8.1.

For the unstable distribution (sid), this problem has been fixed in
version 0.6.1-1.

We recommend that you update your heimdal package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20476-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 476-1 (heimdal)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"heimdal-docs", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-lib", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients-x", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-dev", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-kdc", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers-x", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libasn1-5-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcomerr1-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgssapi1-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libhdb7-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5clnt4-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5srv7-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkafs0-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-17-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libotp0-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libroken9-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsl0-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libss0-heimdal", ver:"0.4e-7.woody.8.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
