# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1768-1 (openafs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63795);
 script_cve_id("CVE-2009-1250", "CVE-2009-1251");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1768-1 (openafs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openafs
announced via advisory DSA 1768-1.

Two vulnerabilities were discovered in the client part of OpenAFS, a
distributed file system.

An attacker with control of a file server or the ability to forge RX
packets may be able to execute arbitrary code in kernel mode on an
OpenAFS client, due to a vulnerability in XDR array decoding.
(CVE-2009-1251)

An attacker with control of a file server or the ability to forge RX
packets may crash OpenAFS clients because of wrongly handled error
return codes in the kernel module. (CVE-2009-1250).

Note that in order to apply this security update, you must rebuild the
OpenAFS kernel module.  Be sure to also upgrade openafs-modules-source,
build a new kernel module for your system following the instructions in
/usr/share/doc/openafs-client/README.modules.gz, and then either stop
and restart openafs-client or reboot the system to reload the kernel
module.

For the old stable distribution (etch), these problems have been fixed
in version 1.4.2-6etch2.

For the stable distribution (lenny), these problems have been fixed in
version 1.4.7.dfsg1-6+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 1.4.10+dfsg1-1.

We recommend that you upgrade your openafs packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201768-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1768-1 (openafs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openafs-doc", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-modules-source", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbg", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-fileserver", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-openafs-kaserver", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-client", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-krb5", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenafs-dev", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbserver", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-kpasswd", ver:"1.4.2-6etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-modules-source", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-doc", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-openafs-kaserver", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbserver", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-kpasswd", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-fileserver", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenafs-dev", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-krb5", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-client", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbg", ver:"1.4.7.dfsg1-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
