# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1763-1 (openssl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63790);
 script_cve_id("CVE-2009-0590");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1763-1 (openssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openssl
announced via advisory DSA 1763-1.

It was discovered that insufficient length validations in the ASN.1
handling of the OpenSSL crypto library may lead to denial of service
when processing a manipulated certificate.

For the old stable distribution (etch), this problem has been fixed in
version 0.9.8c-4etch5 of the openssl package and in version
0.9.7k-3.1etch3 of the openssl097 package.

For the stable distribution (lenny), this problem has been fixed in
version 0.9.8g-15+lenny1.

For the unstable distribution (sid), this problem has been fixed in
version 0.9.8g-16.

We recommend that you upgrade your openssl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201763-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1763-1 (openssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8c-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7k-3.1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8c-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8c-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8c-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7-dbg", ver:"0.9.7k-3.1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8g-15+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8g-15+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8g-15+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8g-15+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
