# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1709-1 (shadow)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63272);
 script_cve_id("CVE-2008-5394");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1709-1 (shadow)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to shadow
announced via advisory DSA 1709-1.

Paul Szabo discovered that login, the system login tool, did not
correctly handle symlinks while setting up tty permissions. If a local
attacker were able to gain control of the system utmp file, they could
cause login to change the ownership and permissions on arbitrary files,
leading to a root privilege escalation.

For the stable distribution (etch), this problem has been fixed in
version 4.0.18.1-7+etch1.

For the unstable distribution (sid), this problem has been fixed in
version 4.1.1-6.

We recommend that you upgrade your shadow package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201709-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1709-1 (shadow)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"login", ver:"4.0.18.1-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"passwd", ver:"4.0.18.1-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
