# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1505-1 (alsa-driver)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60439);
 script_cve_id("CVE-2007-4571");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1505-1 (alsa-driver)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to alsa-driver
announced via advisory DSA 1505-1.

Takashi Iwai supplied a fix for a memory leak in the snd_page_alloc module.
Local users could exploit this issue to obtain sensitive information from
the kernel (CVE-2007-4571).

For the stable distribution (etch), this problem has been fixed in
version 1.0.13-5etch1. This issue was already fixed for the version
of ALSA provided by linux-2.6 in DSA 1479.

For the oldstable distribution (sarge), this problem has been fixed in
version 1.0.8-7sarge1. The prebuilt modules provided by alsa-modules-i386
have been rebuilt to take advantage of this update, and are available in
version 1.0.8+2sarge2.

For the unstable distributions (sid), this problem was fixed in version
1.0.15-1.

We recommend that you upgrade your alsa-driver and alsa-modules-i386

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201505-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1505-1 (alsa-driver)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"alsa-headers", ver:"1.0.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-source", ver:"1.0.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-base", ver:"1.0.8-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-386", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-686", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-386", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-k7-smp", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-k7-smp", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-686-smp", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-686-smp", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-686", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-k6", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-k7", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-k7", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4.27-4-586tsc", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-586tsc", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-modules-2.4-k6", ver:"1.0.8+2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-source", ver:"1.0.13-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"alsa-base", ver:"1.0.13-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-sound-base", ver:"1.0.13-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
