# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1476-1 (pulseaudio)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60269);
 script_cve_id("CVE-2008-0008");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1476-1 (pulseaudio)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to pulseaudio
announced via advisory DSA 1476-1.

Marcus Meissner discovered that the PulseAudio sound server performed
insufficent checks when dropping privileges, which could lead to local
privilege escalation.

For the stable distribution (etch), this problem has been fixed in
version 0.9.5-5etch1.

The old stable distribution (sarge) doesn't contain pulseaudio.

We recommend that you upgrade your pulseaudio packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201476-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1476-1 (pulseaudio)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-jack", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.5-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
